/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.properties.workflowstab;

import filenet.sim.toolkit.designer.properties.resources.VWSIMResource;
import filenet.sim.toolkit.designer.properties.workflowstab.VWSIMWorkflowValidationResultsDialog;
import filenet.vw.api.VWValidationError;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.dialog.VWModalDialog;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JViewport;
import javax.swing.UIManager;

class VWSIMImportFailedDialog
extends VWModalDialog
implements ActionListener,
ComponentListener {
    private static final int MINIMUM_WIDTH = 350;
    private static final int MINIMUM_HEIGHT = 125;
    private JScrollPane m_scrollPane = null;
    private JButton m_closeButton = null;
    private JButton m_detailsButton = null;
    private Frame m_parentFrame = null;
    private VWValidationError[] m_workflowErrors = null;

    public VWSIMImportFailedDialog(Frame parentFrame, String title, VWValidationError[] workflowErrors) {
        super(parentFrame);
        this.setTitle(title);
        this.m_parentFrame = parentFrame;
        this.m_workflowErrors = workflowErrors;
        Dimension dim = VWStringUtils.stringToDimension(VWSIMResource.s_importFailedDialogDim);
        if (dim == null) {
            dim = new Dimension(350, 125);
        }
        this.setSize(dim);
        this.initLayout();
        this.addComponentListener(this);
    }

    public void actionPerformed(ActionEvent event) {
        try {
            Object source = event.getSource();
            if (source.equals(this.m_closeButton)) {
                this.setVisible(false);
            } else if (source.equals(this.m_detailsButton)) {
                this.displayErrorsAndClose();
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public void componentHidden(ComponentEvent event) {
    }

    public void componentMoved(ComponentEvent event) {
    }

    public void componentResized(ComponentEvent event) {
    }

    public void componentShown(ComponentEvent event) {
        JViewport viewport;
        if (event.getSource() != null && event.getSource() == this && this.m_scrollPane != null && (viewport = this.m_scrollPane.getViewport()) != null) {
            Dimension viewportSize = viewport.getSize();
            Dimension viewportPreferredSize = viewport.getPreferredSize();
            if (viewportSize != null && viewportPreferredSize != null) {
                double vpHeight = viewportSize.getHeight();
                double vpPreferredHeight = viewportPreferredSize.getHeight();
                if (vpPreferredHeight > vpHeight) {
                    int nHorizDiff = (int)(vpPreferredHeight - vpHeight);
                    Dimension size = this.getSize();
                    this.setSize((int)size.getWidth(), (int)size.getHeight() + nHorizDiff);
                }
            }
        }
        this.removeComponentListener(this);
    }

    private void initLayout() {
        try {
            Font boldFont;
            this.getContentPane().setLayout(new GridBagLayout());
            GridBagConstraints gbCons = new GridBagConstraints();
            gbCons.gridx = 0;
            gbCons.gridy = 0;
            gbCons.fill = 0;
            gbCons.weightx = 0.0;
            gbCons.weighty = 0.0;
            gbCons.insets = new Insets(5, 5, 5, 10);
            gbCons.gridheight = 1;
            gbCons.gridwidth = 1;
            gbCons.anchor = 23;
            Icon errorIcon = UIManager.getIcon("OptionPane.errorIcon");
            this.getContentPane().add((Component)new JLabel(errorIcon), gbCons);
            ++gbCons.gridx;
            gbCons.fill = 2;
            gbCons.weightx = 1.0;
            gbCons.insets = new Insets(5, 5, 2, 5);
            JTextArea textArea = new JTextArea(VWSIMResource.s_workflowError.toString(this.m_workflowErrors.length + ""));
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            textArea.setEditable(false);
            textArea.setOpaque(false);
            textArea.setBorder(BorderFactory.createEmptyBorder(0, 4, 0, 4));
            this.m_scrollPane = new JScrollPane(textArea);
            this.m_scrollPane.setBorder(BorderFactory.createEmptyBorder());
            this.getContentPane().add((Component)this.m_scrollPane, gbCons);
            Font normalFont = this.getFont();
            if (normalFont != null && (boldFont = new Font(normalFont.getName(), 1, normalFont.getSize())) != null) {
                textArea.setFont(boldFont);
            }
            JPanel buttonPanel = new JPanel();
            buttonPanel.setLayout(new FlowLayout(1, 5, 5));
            this.m_closeButton = new JButton(VWSIMResource.s_close);
            this.m_closeButton.addActionListener(this);
            buttonPanel.add(this.m_closeButton);
            this.m_detailsButton = new JButton(VWSIMResource.s_detailsDots);
            this.m_detailsButton.addActionListener(this);
            buttonPanel.add(this.m_detailsButton);
            gbCons.gridx = 0;
            ++gbCons.gridy;
            gbCons.insets = new Insets(2, 2, 2, 2);
            gbCons.gridwidth = 2;
            gbCons.anchor = 10;
            this.getContentPane().add((Component)buttonPanel, gbCons);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    private void displayErrorsAndClose() {
        VWSIMWorkflowValidationResultsDialog dlg = new VWSIMWorkflowValidationResultsDialog(this.m_parentFrame);
        dlg.displayValidationMessages(this.m_workflowErrors);
        this.setVisible(false);
    }
}

